package org.msh.tb.cases.calculated;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.msh.tb.application.tasks.TaskManager;

import javax.persistence.EntityManager;
import java.util.HashMap;

/**
 * Controller class that updates all tbcases rif resistance field according
 * to the current business rule defined in RifResistanceCalcService.
 *
 * This should be used when the rule in RifResistanceCalcService changes and the already affected cases needs to be updated.
 *
 * Created by msantos on 2018-04-24
 */
@Name("RifResistanceFixService")
@AutoCreate
@Scope(ScopeType.APPLICATION)
public class RifResistanceFixHome {

    @In
    TaskManager taskManager;

    @In
    EntityManager entityManager;

    public String startFixing() {

        Integer firstCaseId = (Integer) entityManager.createNativeQuery("select min(id) from tbcase").getSingleResult();

        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("firstCaseId", firstCaseId);

        String taskId = taskManager.runTask(RifResistanceFixAsyncTask.class, params);

        return taskId;
    }

}
